#!/bin/sh

MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_RESULT_MSG=""
MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_RESULT_OK=0
MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_RESULT_ERROR=1

MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_RESULT_CODE=${MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_RESULT_ERROR}
MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_RESULT_ROLLING=0

master_page_new_esxi_nat_network_conf() {
    debug_print "${0}" "${LINENO}" 'in function "master_page_new_esxi_nat_network_conf"'
	
	local elem="cluster_${new_esxi_sc_id}/nat"
	local ip_address=`dtascfg "$DTASCFG_XML_FILE" get "$elem" ip`
	local netmask=`dtascfg "$DTASCFG_XML_FILE" get ${elem} netmask`
	local dns=`dtascfg "$DTASCFG_XML_FILE" get ${elem} dns`
	local gateway=`dtascfg "$DTASCFG_XML_FILE" get ${elem} gateway`
    
	tp_network_conf \
		"${MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_TITLE}" \
		"${MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_TEXT}" \
		"${MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_LABEL_OK}" \
		"${MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_LABEL_CANCEL}" \
        "${ip_address}" \
        "${netmask}" \
        "${gateway}" \
        "${dns}"
        
    debug_print "${0}" "${LINENO}" "TP_NETWORK_CONF_RESULT_CODE: ${TP_NETWORK_CONF_RESULT_CODE}"
    case "${TP_NETWORK_CONF_RESULT_CODE}" in
    
        "${TP_NETWORK_CONF_RESULT_ERROR}")
            MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_RESULT_CODE=$MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_RESULT_ERROR
            MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_RESULT_ROLLING=0
            MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_RESULT_MSG}"
            return
            ;;
        
        "${TP_NETWORK_CONF_RESULT_CANCEL}")
            MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_RESULT_CODE=$MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_RESULT_OK
            MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_RESULT_ROLLING=-1
            MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_RESULT_MSG=""
            return
            ;;
            
        "${TP_NETWORK_CONF_RESULT_OK}" )
            ;;
        
        *)
            MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_RESULT_CODE=$MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_RESULT_ERROR
            MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_RESULT_ROLLING=0
            MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_RESULT_MSG="${MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_ERROR_UNKNOWN}"
            return
            ;;
    esac
    
	local use_dhcp=0
	# apply and error handling
	utility_apply_cluster_nat_network_conf \
		"${new_esxi_sc_id}" \
		"${use_dhcp}" \
		"${TP_NETWORK_CONF_RESULT_IP}" \
		"${TP_NETWORK_CONF_RESULT_NETMASK}" \
		"${TP_NETWORK_CONF_RESULT_GATEWAY}" \
		"${TP_NETWORK_CONF_RESULT_DNS}"
	if [ "${?}" -ne 0 ]; then
		MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_RESULT_CODE=$MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_RESULT_ERROR
		MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_RESULT_ROLLING=0
		MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_RESULT_MSG="${UTILITY_APPLY_CLUSTER_NAT_NETWORK_CONF_RESULT_MSG}"
		return
	fi
	
	# save to database
	utility_save_cluster_nat_network_conf \
		"${new_esxi_sc_id}" \
		"${use_dhcp}" \
		"${UTILITY_APPLY_CLUSTER_NAT_NETWORK_CONF_RESULT_IP}" \
		"${UTILITY_APPLY_CLUSTER_NAT_NETWORK_CONF_RESULT_NETMASK}" \
		"${UTILITY_APPLY_CLUSTER_NAT_NETWORK_CONF_RESULT_GATEWAY}" \
		"${UTILITY_APPLY_CLUSTER_NAT_NETWORK_CONF_RESULT_DNS}"
	if [ "${?}" -ne 0 ]; then
		MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_RESULT_CODE=$MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_RESULT_ERROR
		MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_RESULT_ROLLING=0
		MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_RESULT_MSG="${UTILITY_SAVE_CLUSTER_NAT_NETWORK_CONF_RESULT_MSG}"
		return
	fi
	
    MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_RESULT_CODE=$MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_RESULT_OK
    MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_RESULT_ROLLING=1
    MASTER_PAGE_NEW_ESXI_NAT_NETWORK_CONF_RESULT_MSG=""
}